package w83b.w83bOperacionesPaso.w83bResultados;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaResultadosCNAEExcelAction extends Q70ActionPasoOP{


	
	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
	}

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoResultadosDelCNAE.xls";
		InputStream inputStream = W83bTablaResultadosCNAEExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        ArrayList resultados = (ArrayList)contexto.get("w83bListadoResultadosBean");
        W83bResultadosBean resultadoBean = (W83bResultadosBean)contexto.get("w83bResultadosBean");                    
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);                    

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);                    
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));                          
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);                    
        HashMap mapaResCNAE=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);                    
        
        HSSFRow row = sheet.getRow((short)4);                    
        HSSFCell cell = row.getCell((short)6);                    
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaResCNAE.get("tituloDepEs");                    
        StringBuffer tituloImagenEu =  (StringBuffer)mapaResCNAE.get("tituloDepEu");                    
        cell.setCellValue(tituloImagenEu.toString());                    
        
        cell = row.getCell((short)11);                    
        cell.setCellValue(tituloImagenEs.toString());                    
        
        tituloImagenEs = (StringBuffer)mapaResCNAE.get("tituloDelelegacionEs");                    
        tituloImagenEu = (StringBuffer)mapaResCNAE.get("tituloDelelegacionEu");                    
        
        
        row = sheet.getRow((short)6);                    
        cell = row.getCell((short)6);                    
        cell.setCellValue(tituloImagenEu.toString());                    
        
        cell = row.getCell((short)11);                    
        cell.setCellValue(tituloImagenEs.toString());                    
        
        
        row = sheet.getRow((short)9);                    
        cell = row.getCell((short)0);                    
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.resultadosCnae").toUpperCase());                    
        
        row = sheet.getRow((short)10); 
        cell = row.createCell((short)6); 
       
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaHistorico())){
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));
    	}
        
        //MAPEO FORMULARIO
        row = sheet.getRow((short)W83bClsConstantes.DOCE);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.territorio"));
        cell = row.createCell((short)3); 
        if(StringUtils.isNotEmpty(resultadoBean.getDescTerritorio())){
        	cell.setCellValue(resultadoBean.getDescTerritorio().toUpperCase());
        }
        
        cell = row.getCell((short)13);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.datosMinisterio.fechaEleccionDesde"));
        cell = row.createCell((short)16); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionDesde())){
        	cell.setCellValue(resultadoBean.getFechaEleccionDesde());
        }
        
        
        row = sheet.getRow((short)W83bClsConstantes.TRECE);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.sector"));
        cell = row.createCell((short)3); 
        if(StringUtils.isNotEmpty(resultadoBean.getSector())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("3"),W83bClsConstantes.TRECE,Short.parseShort("9")));//NOPMD
        	cell.setCellValue(resultadoBean.getSectorTxt());
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell((short)13);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.datosMinisterio.fechaEleccionHasta"));
        cell = row.createCell((short)16); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionHasta())){
        	cell.setCellValue(resultadoBean.getFechaEleccionHasta());
        }
        
        row = sheet.getRow((short)W83bClsConstantes.CATORCE);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.datosMinisterio.fechaResultado"));
        cell = row.createCell((short)3); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaResultadoDesde())){
        	cell.setCellValue(resultadoBean.getFechaResultadoDesde());
        }
        
        cell = row.getCell((short)13);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.datosMinisterio.fechaRegDefinitivo"));
        cell = row.createCell((short)16); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaRegistroDefinitivo())){
        	cell.setCellValue(resultadoBean.getFechaRegistroDefinitivo());
        }
        
        row = sheet.getRow((short)W83bClsConstantes.DIECISIETE);
        cell = row.getCell((short)14);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.certificaciones.centralSindical"));
        
        cell = row.getCell((short)17);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.delegados"));
        
        row = sheet.getRow((short)W83bClsConstantes.DIECIOCHO);
        cell = row.getCell((short)0);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.cnae"));
        cell = row.getCell((short)2);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.numeroActas"));
        cell = row.getCell((short)3);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.numeroCentros"));
        cell = row.getCell((short)5);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.totalelectores").toLowerCase());
        cell = row.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.totalvotantes").toLowerCase());
        cell = row.getCell((short)9);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.totalDelegados"));
        cell = row.getCell((short)12);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.porcentajeParticipacion"));
        cell = row.getCell((short)14);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.codSindicato"));
        cell = row.getCell((short)16);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.siglas"));
        cell = row.getCell((short)17);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegados.numDelegados"));
        cell = row.getCell((short)18);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegados.porcentajeDelegados"));
        //ANTES DE MOSTRARLOS, LOS ORDENO POR CNAE, SINDICATO Y CALCULO LOS TOTALES
        int i=0;
        
//        int total = 0;

        if(StringUtils.isEmpty(resultadoBean.getSector())){
//			String codSectorAnterior="";
			String codSectorActual="";
			HashMap mapaAgrupadoSector=new HashMap();
			ArrayList listaGlobal = new ArrayList();
			//primero agrupo todas las actas por Sector en un HashMap
			for(int z=0;z<resultados.size();z++){
			   W83bResultadosBean resultadoCurrent = (W83bResultadosBean) resultados.get(z);
			   codSectorActual=resultadoCurrent.getDescsector();
			   //va ordenado por sector, por tanto miro si son del mismo sector
			   if(null!=mapaAgrupadoSector.get(codSectorActual)){
			    	//recupero el array de actas que tiene este sector
			    	ArrayList listaSector = (ArrayList) mapaAgrupadoSector.get(codSectorActual);
			    	//aado el acta actual al array
			    	listaSector.add(resultadoCurrent);
			    	//actualizo el mapa
			    	mapaAgrupadoSector.put(codSectorActual, listaSector);
			   }else{
			    	//creo un mapa donde guardare en un array las actas para este sector
			    	ArrayList listaSector = new ArrayList();//NOPMD
			    	listaSector.add(resultadoCurrent);
			    	mapaAgrupadoSector.put(codSectorActual, listaSector);
			    	//actualizo el valor del cnae anterior
//			    	codSectorAnterior=codSectorActual;
			   }
			  
			   listaGlobal.add(resultadoCurrent);
			}
			
			 Map mapSectoresOrdenado = new TreeMap(mapaAgrupadoSector);//NOPMD
			 Iterator it = mapSectoresOrdenado.entrySet().iterator();

		     //para cada sector lo organizo por cnae y lo imprimo
		     while (it.hasNext()) {
		    		Map.Entry e = (Map.Entry)it.next();
		    		ArrayList listaPorSector = (ArrayList) e.getValue();
//		    		total = total + listaPorSector.size();
		    		String tituloSector = (String) e.getKey();
			    		row = sheet.createRow((short)W83bClsConstantes.DIEZYNUEVE+i);
			    		row.setHeightInPoints((short)25);
			    		sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("0"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("1")));//NOPMD
			    		cell = row.createCell((short)0);
			            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.sector").toUpperCase());
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)1);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            
			            cell = row.createCell((short)2);
			            sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("2"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("18")));//NOPMD
			            if(StringUtils.isNotEmpty(tituloSector)){
			            	cell.setCellValue(tituloSector);
			            }
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)3);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)4);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)5);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)6);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)7);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)8);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)9);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)10);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)11);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)12);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)13);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)14);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)15);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)16);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)17);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            cell = row.createCell((short)18);
			            cell.setCellStyle(estiloFilaSector(i,excel));
			            i++;
		    		
		    		
		    		i=imprimirSectores(listaPorSector, sheet, excel, i);
		    		String pTexto = W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.totalSector").toUpperCase();
		    		i=resumenSectores(listaPorSector, sheet, excel, i, pTexto);
		    		i=i+2;
		     }
		    String pTexto = W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.totalTerritorio").toUpperCase();
		    i=resumenSectores(listaGlobal, sheet, excel, i, pTexto);
        }else{
	        i = imprimirSectores(resultados, sheet, excel, i);
	        String pTexto = W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.totalSector").toUpperCase();
	    	i=resumenSectores(resultados, sheet, excel, i, pTexto);
	    	pTexto = W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.totalTerritorio").toUpperCase();
	    	i=resumenSectores(resultados, sheet, excel, i, pTexto);
	    	    	
	        
        }
        
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoResultadosDelegadosCNAE.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
		
	/**
	 * Resumen sectores.
	 *
	 * @param resultados the resultados
	 * @param sheet the sheet
	 * @param excel the excel
	 * @param z the z
	 * @param pCod the cod
	 * @return the int
	 */
	private int resumenSectores(ArrayList resultados, HSSFSheet sheet,W83bUtilidadesExcel excel, int z, String pCod) {
		
		int i = z;
		ArrayList listaOrdenada = ordenarCNAEsindicato(resultados);
		//recupero el total del cnae y la lista por sindicatos
		HashMap mapaFinal = (HashMap) listaOrdenada.get(0);
		HashMap resumenesCNAE = (HashMap) listaOrdenada.get(1);
		int actasTot = 0;
		int centrosTot = 0;
		Iterator it = resumenesCNAE.entrySet().iterator();
    	while (it.hasNext()) {
    		Map.Entry e = (Map.Entry)it.next();
    		ArrayList resumen = (ArrayList) e.getValue();
    		actasTot=actasTot+Integer.parseInt((String) resumen.get(0));
    		centrosTot=centrosTot+Integer.parseInt((String) resumen.get(1));
    	}
		
    	int electoresTot = 0;
		int votantesTot = 0;
		int delTotH = 0;
		int delTotM = 0;
		Iterator itFinal = mapaFinal.entrySet().iterator();
		HashMap mapaActas = new HashMap();
		HashMap mapaActasVot = new HashMap();
		HashMap mapaSindicatos = new HashMap();
		//Recorro los CNAE
    	while (itFinal.hasNext()) {
    		Map.Entry cnaeCurrent = (Map.Entry)itFinal.next();
    		HashMap cnaeMap = (HashMap) cnaeCurrent.getValue();
    		
    		Iterator itSind = cnaeMap.entrySet().iterator();
    		//Recorro  los Sindicatos
        	while (itSind.hasNext()) {
        		Map.Entry sindCurrent = (Map.Entry)itSind.next();
        		        		
        		int delSindicatoH = 0;
        		int delSindicatoM = 0;
        		ArrayList sindArray = (ArrayList) sindCurrent.getValue();
        		//para cada acta
        		for(int h=0; h<sindArray.size();h++){
        			W83bResultadosBean actual = (W83bResultadosBean) sindArray.get(h);
        			
        			ArrayList sindicato = (ArrayList) mapaSindicatos.get(actual.getCodsindicato());
            		if(sindicato==null){
            			sindicato = new ArrayList(4);//NOPMD
            			if (actual.getNumdelegadosH()!=null){
            				delSindicatoH = Integer.parseInt(actual.getNumdelegadosH());
            			}
            			if (actual.getNumdelegadosM()!=null){
            				delSindicatoM = Integer.parseInt(actual.getNumdelegadosM());
            			}
            			sindicato.add(delSindicatoH+"");
            			sindicato.add(delSindicatoM+"");
            			sindicato.add(actual.getCodsindicato()+"");
            			sindicato.add(actual.getSiglas()+"");
            		}else{
            			delSindicatoH = Integer.parseInt(sindicato.get(0)+"");
            			delSindicatoM = Integer.parseInt(sindicato.get(1)+"");
            			if (actual.getNumdelegadosH()!=null){
            				delSindicatoH = delSindicatoH + Integer.parseInt(actual.getNumdelegadosH());
            			}
            			if (actual.getNumdelegadosM()!=null){
            				delSindicatoM = delSindicatoM + Integer.parseInt(actual.getNumdelegadosM());
            			}
            			sindicato.set(0, delSindicatoH+"");
            			sindicato.set(1, delSindicatoM+"");
            		}
            		mapaSindicatos.put(actual.getCodsindicato(), sindicato);
        			String idActaActual = actual.getNacta()+"_"+actual.getAnoacta()+"_"+actual.getTerritorio()+"_"+actual.getVer();
        			W83bResultadosBean actaExiste = (W83bResultadosBean) mapaActas.get(idActaActual);
        			W83bResultadosBean actaExisteVot = (W83bResultadosBean) mapaActasVot.get(idActaActual);
        			if(actaExiste==null){
        				electoresTot = electoresTot+ Integer.parseInt(actual.getTotalelectores());
        				mapaActas.put(idActaActual, actual);
//        				votantesTot = votantesTot+Integer.parseInt(actual.getTotalvotos());
        			}
        			if(actaExisteVot==null&&!"0".equals(actual.getTotalvotos())){
//        				electoresTot = electoresTot+ Integer.parseInt(actual.getTotalelectores());
        				mapaActasVot.put(idActaActual, actual);
        				if (actual.getTotalvotos()!=null){
        					votantesTot = votantesTot+Integer.parseInt(actual.getTotalvotos());
        				}
        			}
        			if (actual.getNumdelegadosH()!=null){
        				delTotH = delTotH+Integer.parseInt(actual.getNumdelegadosH());
    				}
        			if (actual.getNumdelegadosM()!=null){
        				delTotM = delTotM+Integer.parseInt(actual.getNumdelegadosM());
    				}
        		}
        		
        	}

    	}
    	int delegadosTotal = delTotH+delTotM;
        HSSFRow row = sheet.createRow((short)W83bClsConstantes.DIEZYNUEVE+i);
        row.setHeightInPoints((short)25);
        HSSFCell cell = row.createCell((short)0);
        sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("0"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("1")));//NOPMD
        if(StringUtils.isNotEmpty(pCod)){
        	cell.setCellValue(pCod.toUpperCase());
        }
        cell.setCellStyle(estiloFila(i,excel));
        cell = row.createCell((short)1);
        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        cell = row.createCell((short)3);
        if(StringUtils.isNotEmpty(actasTot+"")){
        	cell.setCellValue(W83bUtilidades.numero(actasTot+""));
        }
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
        cell = row.createCell((short)2);
        sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("3"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("4")));//NOPMD
        if(StringUtils.isNotEmpty(centrosTot+"")){
        	cell.setCellValue(W83bUtilidades.numero(centrosTot+""));
        }
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
        cell = row.createCell((short)4);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
        
        cell = row.createCell((short)5);
        sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("5"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("6")));//NOPMD
        if(StringUtils.isNotEmpty(electoresTot+"")){
        	cell.setCellValue(W83bUtilidades.numero(electoresTot+""));
        }
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
        cell = row.createCell((short)6);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
        cell = row.createCell((short)7);
        sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("7"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("8")));//NOPMD
        if(StringUtils.isNotEmpty(votantesTot+"")){
        	cell.setCellValue(W83bUtilidades.numero(votantesTot+""));
        }
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
        cell = row.createCell((short)8);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
        
        cell = row.createCell((short)9);
        sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("9"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("11")));//NOPMD
        if(StringUtils.isNotEmpty(delegadosTotal+"")){
        	cell.setCellValue(W83bUtilidades.numero(delegadosTotal+""));
        }
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
        cell = row.createCell((short)10);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
        cell = row.createCell((short)11);
        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel)); 
        cell = row.createCell((short)12);
        sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("12"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("13")));//NOPMD
        double participacion = (Double.parseDouble(votantesTot+"")/Double.parseDouble(electoresTot+""))*100;
        participacion =W83bUtilidades.redondearDouble(participacion, 2); 
        cell.setCellValue(participacion+" %");
        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        cell = row.createCell((short)13);
        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        
        Iterator itResumenSind = mapaSindicatos.entrySet().iterator();
        int j=0;
		//Recorro  los Sindicatos
        List sindicatosOrdenados=new ArrayList();
    	while (itResumenSind.hasNext()) {
    		Map.Entry sindCurrent = (Map.Entry)itResumenSind.next();
    		ArrayList sindArray = (ArrayList) sindCurrent.getValue();
    		int totDelSind = Integer.parseInt(sindArray.get(0)+"")+Integer.parseInt(sindArray.get(1)+"");
    		sindicatosOrdenados.add(W83bUtilidades.rellenarCaracter(String.valueOf(totDelSind), "0", 6, true)+"|"+sindArray.get(2)+"|"+sindArray.get(3));
    	}
    	Collections.sort(sindicatosOrdenados,Collections.reverseOrder());//la ordenamos de mayor a menor
    	for (int h=0;h<sindicatosOrdenados.size();h++){
         String sindord=(String)sindicatosOrdenados.get(h);
         String[] so=sindord.split("\\|");
    	 row = sheet.createRow((short)W83bClsConstantes.DIEZYNUEVE+i);
   		 if(j==0){
   			 row.setHeightInPoints((short)25);
   			 cell = row.createCell((short)14);
   		     sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("14"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("15")));//NOPMD
   		     	if(!"null".equals(so[1])){
   		     		cell.setCellValue(W83bUtilidades.numero(so[1]+""));
   		     	}else{
   		     		cell.setCellValue("");    		     		
   		     	}
   		        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
   		        cell = row.createCell((short)15);
   		        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
   		           	 
   		        cell = row.createCell((short)16);
   		        if(!"null".equals(so[2])){
   		        	cell.setCellValue(so[2]+"");
   		        }else{
   		        	cell.setCellValue("");    		        	
   		        }
   		        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
   		        cell = row.createCell((short)17);
   		        cell.setCellValue(W83bUtilidades.numero(so[0]+""));
   		        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
   		        double porSindicato;
   		        if(delegadosTotal!=0){
   		        	porSindicato = ((Integer.parseInt(so[0])/Double.parseDouble(delegadosTotal+""))*100);
   	   		        porSindicato = W83bUtilidades.redondearDouble(porSindicato, 2);
   		        }
   		        else{
   		        	porSindicato = 0.00;
   		        }
   		        cell = row.createCell((short)18);
   		        cell.setCellValue(porSindicato+" %");
   		        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
   		 }else{
   			 cell = row.createCell((short)14);
   		     sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("14"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("15")));//NOPMD
   		     	if(!"null".equals(so[1])){
   		     		cell.setCellValue(W83bUtilidades.numero(so[1]+""));
   		     	}else{
   		     		cell.setCellValue("");    		     		
   		     	}
   		        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
   		        cell = row.createCell((short)15);
   		        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
   		           	 
   		        cell = row.createCell((short)16);
   		        if(!"null".equals(so[2])){
   		        	cell.setCellValue(so[2]+"");
   		        }else{
   		        	cell.setCellValue("");    		        	
   		        }
   		        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));    
   		        cell = row.createCell((short)17);
   		        cell.setCellValue(W83bUtilidades.numero(so[0]+""));
   		        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));     
   		        double porSindicato;
   		     	if(delegadosTotal!=0){
   		    	 porSindicato = ((Integer.parseInt(so[0])/Double.parseDouble(delegadosTotal+""))*100);
   		    	 porSindicato = W83bUtilidades.redondearDouble(porSindicato, 2);
		        }
		        else{
		        	porSindicato = 0.00;
		        }
   		        cell = row.createCell((short)18);
   		        cell.setCellValue(porSindicato+" %");
   		        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
   		 }
		        i++;
		        j++;
    	} 
        i=i+2;
		return i;
	}

	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
				
			return excel.styleTextoParNumeroCentrado;
		
	}
	
	
	private HSSFCellStyle estiloFilaNumeroCentradoFormateado(int nFila, W83bUtilidadesExcel excel){
		return excel.styleTextoParNumeroCentradoFormateado;//NOPMD
	}
	/**
	 * Estilo fila.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		
			return excel.styleTextoPar;		
	}
	
	/**
	 * Ordenar cna esindicato.
	 *
	 * @param resultados the resultados
	 * @return the array list
	 */
	private ArrayList ordenarCNAEsindicato(ArrayList resultados){
		ArrayList listaOrdenada = new ArrayList();
		String codCnaeAnterior="";
		String codCnaeActual="";
		HashMap mapaAgrupadoCNAE=new HashMap();
		//primero agrupo todas las actas por CNAE en un HashMap
		for(int i=0;i<resultados.size();i++){
			W83bResultadosBean resultadoCurrent = (W83bResultadosBean) resultados.get(i);
			codCnaeActual=resultadoCurrent.getDesccnae();
			//va ordenado por cnae, por tanto miro si son del mismo cnae
			if(codCnaeActual.equalsIgnoreCase(codCnaeAnterior)){
				//recupero el array de actas que tiene este CNAE
				ArrayList listaCNAE = (ArrayList) mapaAgrupadoCNAE.get(codCnaeActual);
				//aado el acta actual al array
				listaCNAE.add(resultadoCurrent);
				//actualizo el mapa
				mapaAgrupadoCNAE.put(codCnaeActual, listaCNAE);
			}else{
				//creo un mapa donde guardare en un array las actas para este CNAE
				ArrayList listaCNAE = new ArrayList();//NOPMD
				listaCNAE.add(resultadoCurrent);
				mapaAgrupadoCNAE.put(codCnaeActual, listaCNAE);
				//actualizo el valor del cnae anterior
				codCnaeAnterior=codCnaeActual;
			}
		}
		Map mapCNAEOrdenado = new TreeMap(mapaAgrupadoCNAE);//NOPMD
		Iterator it = mapCNAEOrdenado.entrySet().iterator();
		//Ahora recorro cada CNAE y lo agrupo por sindicato
		HashMap mapaFinal = new HashMap();//NOPMD
		HashMap resumenesCNAE = new HashMap();//NOPMD
    	while (it.hasNext()) {
    		Map.Entry e = (Map.Entry)it.next();
    		//recupero su clave
    		String codCnae = (String) e.getKey();
    		//recupero su array de actas
    		ArrayList listaCNAE = (ArrayList) e.getValue();
    		//Para cada CNAE creo una tabla de sindicatos
    		HashMap mapaSindicatos = new HashMap();//NOPMD
    		//calculo el total de actas y el total de centros
    		HashMap mapaActasEsteCNAE=new HashMap();//NOPMD
    		HashMap mapaCentrosEsteCNAE=new HashMap();//NOPMD
    		
    		String idSindicatoActual="";
    		String idActaActual="";
    		int numActas=0;
    		String idCentroActual="";
    		int numCentros=0;
    		//recorro el array de actas de este CNAE
    		for(int i=0;i<listaCNAE.size();i++){
    			W83bResultadosBean resultadoCurrent = (W83bResultadosBean) listaCNAE.get(i);
    			idSindicatoActual = resultadoCurrent.getCodsindicato();
    			//busco si existe una tabla para este sindicato 
    			ArrayList listaSindicato = (ArrayList) mapaSindicatos.get(idSindicatoActual);
    			if(listaSindicato==null){
    				//si no existe tengo que crear el array e ingresarlo
    				listaSindicato = new ArrayList();//NOPMD
    				listaSindicato.add(resultadoCurrent);
    				mapaSindicatos.put(idSindicatoActual, listaSindicato);
    			}else{
    				//si existe, lo aado y actualizo
    				listaSindicato.add(resultadoCurrent);
    				mapaSindicatos.put(idSindicatoActual, listaSindicato);
    			}
    			
    			idActaActual = resultadoCurrent.getNacta()+"_"+resultadoCurrent.getAnoacta()+"_"+resultadoCurrent.getTerritorio()+"_"+resultadoCurrent.getVer();
    			//busco si existe en la tabla esta acta 
    			String estaActa = (String) mapaActasEsteCNAE.get(idActaActual);
    			if(estaActa==null){
    				//si no existe aumento el contador y lo aado
    				numActas++;
    				mapaActasEsteCNAE.put(idActaActual, idActaActual);
    			}
    			
    			idCentroActual = resultadoCurrent.getNcentro();
    			//busco si existe en la tabla este centro
    			String estaCentro = (String) mapaCentrosEsteCNAE.get(idCentroActual);
    			if(estaCentro==null){
    				//si no existe aumento el contador y lo aado
    				numCentros++;
    				mapaCentrosEsteCNAE.put(idCentroActual, idCentroActual);
    			}
    			
    		}
    		//creo un array para cada CNAE donde guardo el total actas y el total centros
    		ArrayList resumenCNAE = new ArrayList();//NOPMD
    		resumenCNAE.add(0,numActas+"");
    		resumenCNAE.add(0,numCentros+"");
    		//guardo en una tabla resumen este array
    		resumenesCNAE.put(codCnae, resumenCNAE);
    		//guardo tambien el mapa de sindicatos para este CNAE
    		mapaFinal.put(codCnae, mapaSindicatos);
    	}
    	listaOrdenada.add(mapaFinal);
    	listaOrdenada.add(resumenesCNAE);
		
		return listaOrdenada;
	}
	
	
	
	/**
	 * Imprimir sectores.
	 *
	 * @param resultados the resultados
	 * @param sheet the sheet
	 * @param excel the excel
	 * @param fila the fila
	 * @return the int
	 */
	private int imprimirSectores(ArrayList resultados,HSSFSheet sheet,W83bUtilidadesExcel excel, int fila){
		ArrayList listaOrdenada = ordenarCNAEsindicato(resultados);
	    int i = fila;
        HashMap mapaFinal = (HashMap) listaOrdenada.get(0);
        HashMap mapaResumen = (HashMap) listaOrdenada.get(1);
        
        Map mapaFinalOrdenado = new TreeMap(mapaFinal);//NOPMD
        Iterator it = mapaFinalOrdenado.entrySet().iterator();
        
        //para cada CNAE
    	while (it.hasNext()) {
    		Map.Entry e = (Map.Entry)it.next();
    		//recupero su clave
    		String codCnae = (String) e.getKey();
    		//recupero su mapa de sindicatos para este CNAE
    		HashMap mapaPorSindicato = (HashMap) e.getValue();
    		//registro de actas, para no duplicar el total electores
    		HashMap mapaActas = new HashMap();//NOPMD
    		HashMap mapaActasVot = new HashMap();//NOPMD
    		int totalElect=0;
    		int totalVot=0;
    		int totalDelH=0;
    		int totalDelM=0;
    		int totalDelegados=0;
    		//obtengo los valores totales
    		Iterator itSindicatos = mapaPorSindicato.entrySet().iterator();
    		//para cada sindicato del CNAE
        	while (itSindicatos.hasNext()) {
        		Map.Entry eSind = (Map.Entry)itSindicatos.next();
        		//recupero su mapa de sindicatos para este CNAE
        		ArrayList arraySindicato = (ArrayList) eSind.getValue();
        		//para cada acta del sindicato
        		for(int j=0; j<arraySindicato.size();j++){
        			W83bResultadosBean beanCurrent = (W83bResultadosBean) arraySindicato.get(j);
        			String idActaActual = beanCurrent.getNacta()+"_"+beanCurrent.getAnoacta()+"_"+beanCurrent.getTerritorio()+"_"+beanCurrent.getVer();
        			W83bResultadosBean b = (W83bResultadosBean) mapaActas.get(idActaActual);
        			W83bResultadosBean bVot = (W83bResultadosBean) mapaActasVot.get(idActaActual);
        			if(b==null){
        				mapaActas.put(idActaActual, beanCurrent);
        				if(!StringUtils.isEmpty(beanCurrent.getTotalelectores())){
        					totalElect = totalElect + Integer.parseInt(beanCurrent.getTotalelectores());
        				}
//        				if(!StringUtils.isEmpty(beanCurrent.getTotalvotos())){
//        					totalVot = totalVot + Integer.parseInt(beanCurrent.getTotalvotos());
//        				}
        			}
        			if(bVot==null&&!"0".equals(beanCurrent.getTotalvotos())){
        				mapaActasVot.put(idActaActual, beanCurrent);
//        				if(!StringUtils.isEmpty(beanCurrent.getTotalelectores())){
//        					totalElect = totalElect + Integer.parseInt(beanCurrent.getTotalelectores());
//        				}
        				if(!StringUtils.isEmpty(beanCurrent.getTotalvotos())){
        					totalVot = totalVot + Integer.parseInt(beanCurrent.getTotalvotos());
        				}
        			}
        			
        			if(!StringUtils.isEmpty(beanCurrent.getNumdelegadosH())){
        				totalDelH = totalDelH + Integer.parseInt(beanCurrent.getNumdelegadosH());
    				}
        			if(!StringUtils.isEmpty(beanCurrent.getNumdelegadosM())){
        				totalDelM = totalDelM + Integer.parseInt(beanCurrent.getNumdelegadosM());
    				}
        		}
        	}
        	totalDelegados = totalDelH+totalDelM;
    		//PARA CADA CNAE:
    		ArrayList arrayResumen = (ArrayList) mapaResumen.get(codCnae);
    		
            HSSFRow row = sheet.createRow((short)W83bClsConstantes.DIEZYNUEVE+i);
            HSSFCell cell = row.createCell((short)0);
            sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("0"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("1")));//NOPMD
            if(StringUtils.isNotEmpty(codCnae)){
            	cell.setCellValue(codCnae);
            }
            cell.setCellStyle(estiloFila(i,excel));
            cell = row.createCell((short)1);
            cell.setCellStyle(estiloFila(i,excel));
             
             cell = row.createCell((short)3);
             cell.setCellValue(W83bUtilidades.numero(arrayResumen.get(0)+""));
             cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
             
             cell = row.createCell((short)2);
             sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("3"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("4")));//NOPMD
             cell.setCellValue(W83bUtilidades.numero(arrayResumen.get(1)+""));
             cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
             cell = row.createCell((short)4);
             cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
             
             cell = row.createCell((short)5);
             sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("5"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("6")));//NOPMD
             cell.setCellValue(W83bUtilidades.numero(totalElect+""));
             cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
             cell = row.createCell((short)6);
             cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
             
             cell = row.createCell((short)7);
             sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("7"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("8")));//NOPMD
             cell.setCellValue(W83bUtilidades.numero(totalVot+""));
             cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
             cell = row.createCell((short)8);
             cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
             
             cell = row.createCell((short)9);
             sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("9"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("11")));//NOPMD
             cell.setCellValue(W83bUtilidades.numero(totalDelegados+""));
             cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
             cell = row.createCell((short)10);
             cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
             cell = row.createCell((short)11);
             cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel)); 
             	                 
             double participacion = (Double.parseDouble(totalVot+"")/Double.parseDouble(totalElect+""))*100;
             participacion =W83bUtilidades.redondearDouble(participacion, 2); 
             
             cell = row.createCell((short)12);
             sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("12"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("13")));//NOPMD
             cell.setCellValue(participacion+" %");
             cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
             cell = row.createCell((short)13);
             cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
             
             List sindicatosOrdenados=new ArrayList();//NOPMD
             itSindicatos = mapaPorSindicato.entrySet().iterator();
             while (itSindicatos.hasNext()) {
          		Map.Entry eSind = (Map.Entry)itSindicatos.next();
          		//recupero su clave
          		String codSind = (String) eSind.getKey();
          		//recupero su mapa de sindicatos para este CNAE
          		ArrayList arraySindicato = (ArrayList) eSind.getValue();
          		int sindicatoDelH=0;
         		int sindicatoDelM=0;
         		String siglasSindicato="";
          		//para cada acta del sindicato
          		for(int j=0; j<arraySindicato.size();j++){
          			W83bResultadosBean beanCurrent = (W83bResultadosBean) arraySindicato.get(j);
          			siglasSindicato = beanCurrent.getSiglas();
          			if(!StringUtils.isEmpty(beanCurrent.getNumdelegadosH())){
          				sindicatoDelH = sindicatoDelH + Integer.parseInt(beanCurrent.getNumdelegadosH());
      				}
          			if(!StringUtils.isEmpty(beanCurrent.getNumdelegadosM())){
          				sindicatoDelM = sindicatoDelM + Integer.parseInt(beanCurrent.getNumdelegadosM());
      				}         			
          		}
          		int totalSin = sindicatoDelH+sindicatoDelM;
          		sindicatosOrdenados.add(W83bUtilidades.rellenarCaracter(String.valueOf(totalSin), "0", 6, true)+"|"+codSind+"|"+siglasSindicato+"|"+sindicatoDelH+"|"+sindicatoDelM);
          	}
            Collections.sort(sindicatosOrdenados,Collections.reverseOrder());//la ordenamos de mayor a menor
            for (int j=0;j<sindicatosOrdenados.size();j++){
            	String sindord=(String)sindicatosOrdenados.get(j);
            	String[] so=sindord.split("\\|");            	
            		row = sheet.createRow((short)W83bClsConstantes.DIEZYNUEVE+i);
    		        cell = row.createCell((short)14);
    		        sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("14"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("15")));//NOPMD
    		        if(StringUtils.isNotEmpty(so[1])&&!"null".equals(so[1])){
    		        	cell.setCellValue(W83bUtilidades.numero(so[1]));
    		        }
    		        else{
    		        	cell.setCellValue(W83bClsConstantes.VACIO);
    		        }
    		        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
    		        cell = row.createCell((short)15);
    		        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
    		           	 
    		        cell = row.createCell((short)16);
    		        if(StringUtils.isNotEmpty(so[2])&&!"null".equals(so[2])){
    		        	cell.setCellValue(so[2]);
    		        }
    		        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
    		                
    		        cell = row.createCell((short)17);
    		        cell.setCellValue(W83bUtilidades.numero(so[0]+""));
    		        cell.setCellStyle(estiloFilaNumeroCentradoFormateado(i,excel));
    		                
    		        double porSindicato;
    		        
    		        cell = row.createCell((short)18);
    		        if(totalDelegados!=0){
    		        	porSindicato = ((Integer.parseInt(so[0])/Double.parseDouble(totalDelegados+""))*100);
        		        porSindicato = W83bUtilidades.redondearDouble(porSindicato, 2);
    		        }
    		        else{
    		        	porSindicato=0.00;
    		        }
    		        cell.setCellValue(porSindicato+" %");
    		        cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
    		        i++;
            	
            	
            }
            i = i+2; 
         	}
    		
    	
    	return i;
	}
	
	private HSSFCellStyle estiloFilaSector(int nFila, W83bUtilidadesExcel excel){
		return excel.styleCabecera;
	}
}
